package ga.core.individual;

/**
 * Interface for adding interval fitness to individuals.<br />
 * The interval has a {@code minimum} and {@code maximum}, the
 * {@code width (maximum - minimum)} and a {@code center (maximum - width/2)}.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IIntervalFitness extends IFitness {

  /**
   * Getter for the minimum fitness.
   * 
   * @return The min fitness.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public double getMinFitness();

  /**
   * Getter for the maximum fitness.
   * 
   * @return The max fitness.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public double getMaxFitness();

  /**
   * Getter for the fitness width (max-min).
   * 
   * @return The width.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public double getFitnessWidth();

  /**
   * Sets the fitness interval by its center and width.
   * 
   * @param center
   *          Center of the fitness interval.
   * @param width
   *          The width of the fitness interval.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void setFitnessInterval(double center, double width);

  /**
   * Sets the fitness interval by its minimum and maximum.
   * 
   * @param min
   *          Minimum fitness.
   * @param max
   *          Maximum fitness.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void setFitnessLimits(double min, double max);
}
